<?php
session_start();

include 'include/head.php';

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

if (!isset($_GET['id'])) {
    header('Location: groupes.php');
}

$id = $_GET['id'];

if (isset($_GET['supprimer'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();
        $requete = $bdd->prepare("DELETE FROM groupe WHERE id=:id");
        $requete->bindParam(':id', $id);
        $requete->execute();
        $bdd->commit();

        header('Location: eleves.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }
}

if (isset($_POST['nom'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();

        $requete = $bdd->prepare('UPDATE groupe SET nom=:nom WHERE id=:id');
        $requete->bindParam(':nom', $_POST['nom']);
        $requete->bindParam(':id', $id);
        $requete->execute();

        if ($_POST['id_eleve_ajout'] != '') {
            $requete = $bdd->prepare('INSERT INTO groupe_eleve (id_eleve4, id_groupe) VALUES (:id_eleve, :id_groupe)');
            $requete->bindParam(':id_eleve', $_POST['id_eleve_ajout']);
            $requete->bindParam(':id_groupe', $id);
            $requete->execute();
        }

        if ($_POST['id_eleve_suppression'] != '') {
            $requete = $bdd->prepare('DELETE FROM groupe_eleve WHERE id_eleve4=:id_eleve AND id_groupe=:id_groupe');
            $requete->bindParam(':id_eleve', $_POST['id_eleve_suppression']);
            $requete->bindParam(':id_groupe', $id);
            $requete->execute();
        }

        $bdd->commit();

        header('Location: groupes.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }

}

$requete = $bdd->prepare("SELECT * FROM groupe WHERE id=:id");
$requete->bindParam(':id', $id);
$requete->execute();
$groupe = $requete->fetch();

include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading"> Modification d'un groupe - <a href="edition-groupe.php?id=<?php echo htmlspecialchars($id) ?>&supprimer">Supprimer ce groupe</a> </div>
                        <div class="panel-body">
                            <div class="form-group">
                                <form method="post">
                                    <label>Nom</label>
                                    <input class="form-control" name="nom" value="<?php echo htmlspecialchars($groupe['nom']) ?>">
                                    <label>Élève à ajouter</label>
                                    <select class="form-control" name="id_eleve_ajout">
                                        <option value="">Aucun</option>
                                        <?php
                                        $requete = $bdd->prepare("SELECT nom, prenom, id_eleve FROM eleve");
                                        $requete->execute();
                                        while ( $row = $requete->fetch())
                                            echo '<option value="'.htmlspecialchars($row['id_eleve']).'">'.htmlspecialchars($row['prenom'].' '.$row['nom']).'</option>';
                                        ?>
                                    </select>
                                    <label>Élève à supprimer</label>
                                    <select class="form-control" name="id_eleve_suppression">
                                        <option value="">Aucun</option>
                                        <?php
                                        $requete = $bdd->prepare("SELECT nom, prenom, id_eleve FROM eleve");
                                        $requete->execute();
                                        while ( $row = $requete->fetch())
                                            echo '<option value="'.htmlspecialchars($row['id_eleve']).'">'.htmlspecialchars($row['prenom'].' '.$row['nom']).'</option>';
                                        ?>
                                    </select>
                                    <br />
                                    <input type="submit">
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
